/*  
 * Copyright (C) 2005 Martin Pischky (mailto:martin@pischky.de)  
 *
 * This file (HexFileReaderTest.java) is part of IntelHexFile.
 *
 * IntelHexFile is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 */

/*
 * $Log: HexFileReaderTest.java,v $
 * Revision 1.1  2005/03/27 12:29:58  pischky
 * added
 *
 */

package org.fremo.ihx.test;

import java.io.IOException;
import java.io.StringReader;

import org.fremo.ihx.HexFileReader;
import org.fremo.ihx.InvalidHexFileException;
import org.fremo.ihx.Memory;

import junit.framework.TestCase;

/**
 * @author martin
 */
public class HexFileReaderTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(HexFileReaderTest.class);
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /* (non-Javadoc)
     * @see junit.framework.TestCase#runTest()
     */
    protected void runTest() throws Throwable {
       super.runTest();
    }
    
    public void testReader1() 
    throws InvalidHexFileException, IOException 
    {
        String s = ":04003F00A42EFE22CB\r\n"
                 + ":00000001FF";
        HexFileReader hr = new HexFileReader( new StringReader( s ) );
        Memory mem = hr.read();
        hr.close();
        assertEquals( 0xA4, mem.get(0x003F) );
        assertEquals( 0x2E, mem.get(0x003F+1) );
        assertEquals( 0xFE, mem.get(0x003F+2) );
        assertEquals( 0x22, mem.get(0x003F+3) );
        assertEquals( Memory.UNDEFINED, mem.get(0x003F+4) );
    }
    
    public void testReader2() 
    throws InvalidHexFileException, IOException 
    {
        String s = ":10246200464C5549442050524F46494C4500464C33\r\n"
                 + ":00000001FF\r\n";      
        HexFileReader hr = new HexFileReader( new StringReader( s ) );
        Memory mem = hr.read();
        hr.close();
        assertEquals( 0x46, mem.get(0x2462) );
        assertEquals( 0x4C, mem.get(0x2462+1) );
        assertEquals( 0x55, mem.get(0x2462+2) );
        assertEquals( 0x49, mem.get(0x2462+3) );
        assertEquals( 0x44, mem.get(0x2462+4) );
        assertEquals( 0x20, mem.get(0x2462+5) );
        assertEquals( 0x50, mem.get(0x2462+6) );
        assertEquals( 0x52, mem.get(0x2462+7) );
        assertEquals( 0x4F, mem.get(0x2462+8) );
        assertEquals( 0x46, mem.get(0x2462+9) );
        assertEquals( 0x49, mem.get(0x2462+10) );
        assertEquals( 0x4C, mem.get(0x2462+11) );
        assertEquals( 0x45, mem.get(0x2462+12) );
        assertEquals( 0x00, mem.get(0x2462+13) );
        assertEquals( 0x46, mem.get(0x2462+14) );
        assertEquals( 0x4C, mem.get(0x2462+15) );
        assertFalse( mem.isDefined(0x2462+16) );
    }
    
    public void testReader3() 
    throws InvalidHexFileException, IOException 
    {
        String s = ":10246200464C5549442050524F46494C4500464C33\r\n"
                 + ":04003F00A42EFE22CB\r\n"
                 + ":00000001FF\r\n";      
        HexFileReader hr = new HexFileReader( new StringReader( s ) );
        Memory mem = hr.read();
        hr.close();
        for (int i = 0; i < 0x003F; i++) {
            assertFalse( mem.isDefined(i) );            
        }
        assertEquals( 0xA4, mem.get(0x003F) );
        assertEquals( 0x2E, mem.get(0x003F+1) );
        assertEquals( 0xFE, mem.get(0x003F+2) );
        assertEquals( 0x22, mem.get(0x003F+3) );
        for (int i = 0x003F+4; i < 0x2462; i++) {
            assertFalse( mem.isDefined(i) );            
        }
        assertEquals( 0x46, mem.get(0x2462) );
        assertEquals( 0x4C, mem.get(0x2462+1) );
        assertEquals( 0x55, mem.get(0x2462+2) );
        assertEquals( 0x49, mem.get(0x2462+3) );
        assertEquals( 0x44, mem.get(0x2462+4) );
        assertEquals( 0x20, mem.get(0x2462+5) );
        assertEquals( 0x50, mem.get(0x2462+6) );
        assertEquals( 0x52, mem.get(0x2462+7) );
        assertEquals( 0x4F, mem.get(0x2462+8) );
        assertEquals( 0x46, mem.get(0x2462+9) );
        assertEquals( 0x49, mem.get(0x2462+10) );
        assertEquals( 0x4C, mem.get(0x2462+11) );
        assertEquals( 0x45, mem.get(0x2462+12) );
        assertEquals( 0x00, mem.get(0x2462+13) );
        assertEquals( 0x46, mem.get(0x2462+14) );
        assertEquals( 0x4C, mem.get(0x2462+15) );
        for (int i = 0x2462+16; i < 65536; i++) {
            assertFalse( mem.isDefined(i) );            
        }
    }
    
    public void testReader4() 
    throws InvalidHexFileException, IOException 
    {
        String s = ":10001300AC12AD13AE10AF1112002F8E0E8F0F2244\r\n"
                 + ":10000300E50B250DF509E50A350CF5081200132259\r\n"
                 + ":03000000020023D8\r\n"
                 + ":0C002300787FE4F6D8FD7581130200031D\r\n"
                 + ":10002F00EFF88DF0A4FFEDC5F0CEA42EFEEC88F016\r\n"
                 + ":04003F00A42EFE22CB\r\n"
                 + ":00000001FF\r\n";      
        HexFileReader hr = new HexFileReader( new StringReader( s ) );
        Memory mem = hr.read();
        hr.close();
    }
    
    //TODO: test errornous files
}
